/*
 * Decompiled with CFR 0.152.
 */
package kayttoliittyma;

import dimensioanalyysi.Apu;
import dimensioanalyysi.Matriisi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanelMatriisi
extends JPanel {
    private int rivit;
    private int sarakkeet;
    private GridLayout gridLayout;

    public JPanelMatriisi(int rivit, int sarakkeet) {
        this.rivit = rivit;
        this.sarakkeet = sarakkeet;
        this.gridLayout = new GridLayout(rivit, sarakkeet);
        this.setLayout(this.gridLayout);
        int i = 0;
        while (i < rivit * sarakkeet) {
            JTextField textField = new JTextField(4);
            textField.setFont(new Font("Serif", 0, 16));
            this.add(textField);
            ++i;
        }
    }

    public JPanelMatriisi(String[][] tulostus) {
        this(tulostus.length, tulostus[0].length);
        int r = 0;
        int s = 0;
        int i = 0;
        while (i < this.rivit * this.sarakkeet) {
            JTextField textField = (JTextField)this.getComponent(i);
            textField.setEditable(false);
            String tul = tulostus[r][s];
            if (r == 0 && s == 0) {
                textField.setBackground(Color.lightGray);
            } else if (r == 0 ^ s == 0) {
                StringBuffer sb = new StringBuffer(tul);
                String nimi = "";
                String symboli = "";
                try {
                    nimi = Apu.erota(sb, "|");
                    symboli = Apu.erota(sb, "|");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.remove(i);
                JLabel label = new JLabel();
                if (symboli.length() > 5) {
                    label.setText("<html>" + symboli + "</html>");
                } else {
                    label.setText(symboli);
                }
                label.setFont(new Font("Serif", 3, 16));
                label.setOpaque(true);
                label.setBackground(Color.lightGray);
                this.add((Component)label, i);
                label.setToolTipText(nimi);
            } else {
                textField.setText(tul);
                textField.setBackground(Color.white);
            }
            if (s == this.sarakkeet - 1) {
                s = 0;
                ++r;
            } else {
                ++s;
            }
            ++i;
        }
    }

    public Matriisi lueArvot() {
        Matriisi M = new Matriisi(this.rivit, this.sarakkeet);
        int r = 0;
        int s = 0;
        int i = 0;
        while (i < this.rivit * this.sarakkeet) {
            double arvo;
            JTextField alkio = (JTextField)this.getComponent(i);
            String st = alkio.getText();
            if (st == null || st.equals("")) {
                return null;
            }
            try {
                arvo = Double.parseDouble(st);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            M.setAlkio(r, s, arvo);
            if (s == this.sarakkeet - 1) {
                s = 0;
                ++r;
            } else {
                ++s;
            }
            ++i;
        }
        return M;
    }
}

