/*
 * Decompiled with CFR 0.152.
 */
package dimensioanalyysi;

import dimensioanalyysi.Apu;

public class Matriisi {
    private int rivit;
    private int sarakkeet;
    private double[][] alkiot;

    public Matriisi(int rivit, int sarakkeet) {
        this.rivit = rivit;
        this.sarakkeet = sarakkeet;
        this.alkiot = new double[rivit][sarakkeet];
    }

    public Matriisi(double[][] alkiot) {
        this.rivit = alkiot.length;
        this.sarakkeet = alkiot[0].length;
        this.alkiot = alkiot;
    }

    public Matriisi(double[] alkiot) {
        this.rivit = 1;
        this.sarakkeet = alkiot.length;
        this.alkiot = new double[this.rivit][this.sarakkeet];
        this.alkiot[0] = alkiot;
    }

    public int getRivit() {
        return this.rivit;
    }

    public int getSarakkeet() {
        return this.sarakkeet;
    }

    public double getAlkio(int rivi, int sarake) {
        return this.alkiot[rivi][sarake];
    }

    public double[] getRivi(int rivi) {
        double[] kopio = new double[this.sarakkeet];
        int i = 0;
        while (i < this.sarakkeet) {
            kopio[i] = this.getAlkio(rivi, i);
            ++i;
        }
        return kopio;
    }

    public String[][] getAlkioTaulukko() {
        String[][] alkiot = new String[this.rivit][this.sarakkeet];
        int i = 0;
        while (i < this.rivit) {
            int j = 0;
            while (j < this.sarakkeet) {
                alkiot[i][j] = "" + Apu.pyorista(this.alkiot[i][j]);
                ++j;
            }
            ++i;
        }
        return alkiot;
    }

    public String[] getRiviTaulukko(int rivi) {
        String[] alkiot = new String[this.sarakkeet];
        int i = 0;
        while (i < this.sarakkeet) {
            alkiot[i] = "" + Apu.pyorista(this.alkiot[rivi][i]);
            ++i;
        }
        return alkiot;
    }

    public void setAlkio(int rivi, int sarake, double alkio) {
        this.alkiot[rivi][sarake] = alkio;
    }

    public void setRivi(int rivi, double[] alkiot) {
        int i = 0;
        while (i < this.getSarakkeet()) {
            this.setAlkio(rivi, i, alkiot[i]);
            ++i;
        }
    }

    public void setMatriisi(double[][] alkiot) {
        int i = 0;
        while (i < this.getRivit()) {
            this.setRivi(i, alkiot[i]);
            ++i;
        }
    }

    public void vaihdaRivit(int rivi1, int rivi2) {
        double[] apu = this.getRivi(rivi1);
        this.setRivi(rivi1, this.getRivi(rivi2));
        this.setRivi(rivi2, apu);
    }

    public static Matriisi kerro(Matriisi A, Matriisi B, Matriisi vastaus) {
        if (A.getSarakkeet() != B.getRivit()) {
            return null;
        }
        vastaus = new Matriisi(A.getRivit(), B.getSarakkeet());
        int i = 0;
        while (i < A.getRivit()) {
            int j = 0;
            while (j < B.getSarakkeet()) {
                int arvo = 0;
                int k = 0;
                while (k < A.getSarakkeet()) {
                    arvo = (int)((double)arvo + A.getAlkio(i, k) * B.getAlkio(k, j));
                    ++k;
                }
                vastaus.setAlkio(i, j, arvo);
                ++j;
            }
            ++i;
        }
        return vastaus;
    }

    public void tulosta() {
        int i = 0;
        while (i < this.rivit) {
            int j = 0;
            while (j < this.sarakkeet) {
                System.out.print(this.alkiot[i][j] + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rivit) {
            int j = 0;
            while (j < this.sarakkeet) {
                String luku = Apu.pyorista(this.alkiot[i][j]);
                sb.append(luku + "   ");
                ++j;
            }
            sb.append(" \n");
            ++i;
        }
        return sb.toString();
    }

    public String riviToString(int rivi) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.sarakkeet) {
            String luku = Apu.pyorista(this.alkiot[rivi][i]);
            sb.append(luku + "   ");
            ++i;
        }
        return sb.toString();
    }

    public Object clone() {
        Matriisi M = new Matriisi(this.rivit, this.sarakkeet);
        int i = 0;
        while (i < this.rivit) {
            M.setRivi(i, this.getRivi(i));
            ++i;
        }
        return M;
    }

    public static void main(String[] args) {
        Matriisi A = new Matriisi(3, 5);
        Matriisi B = new Matriisi(5, 2);
        Object V = null;
        double[][] testi1 = new double[][]{{1.0, 2.499999, 3.999999, -4.500000001, 5.0}, {1.0, 2.0, 3.0, 4.0, 5.0}, {1.0, 2.0, -3.0, 4.0, -5.0}};
        double[][] testi2 = new double[][]{{1.0, 2.0}, {-5.0, 4.0}, {1.0, 2.0}, {0.0, 4.0}, {3.0, 0.0}};
        double[][] taulu = new double[][]{{1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 2.0, -1.0}};
        Matriisi T = new Matriisi(taulu);
        T.tulosta();
        T.vaihdaRivit(0, 2);
        T.tulosta();
    }
}

