/*
 * Decompiled with CFR 0.152.
 */
package dimensioanalyysi;

import dimensioanalyysi.Aihe;
import dimensioanalyysi.Aiheet;
import dimensioanalyysi.Dimensio;
import dimensioanalyysi.Dimensiomatriisi;
import dimensioanalyysi.Dimensiot;
import dimensioanalyysi.Matriisi;
import dimensioanalyysi.Ohje;
import dimensioanalyysi.Perussuure;
import dimensioanalyysi.Perussuureet;
import dimensioanalyysi.Piiluku;
import dimensioanalyysi.Piiluvut;
import dimensioanalyysi.Suure;
import dimensioanalyysi.Suureet;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Dimensioanalyysi {
    private Aiheet aiheet = new Aiheet();
    private Dimensiot dimensiot = new Dimensiot();
    private Perussuureet perussuureet = new Perussuureet();
    private Piiluvut piiluvut = new Piiluvut();
    private Suureet suureet = new Suureet();
    private Ohje ohje = new Ohje();
    private Dimensiomatriisi DM;
    private ArrayList valitut;
    private String[][] tulostus;

    public int getSeuraava() {
        return this.aiheet.getSeuraava();
    }

    public Vector getAiheet() {
        return this.aiheet.getAiheet();
    }

    public Vector getPerussuureet() {
        return this.perussuureet.getPerussuureet();
    }

    public String[][] getTulostus() {
        return this.tulostus;
    }

    public String getOhje() {
        return this.ohje.getOhje();
    }

    public String[][] laskePiiluvut(Matriisi M, String aihe, int idPerussuure) {
        Matriisi muuttuva = (Matriisi)M.clone();
        this.DM = new Dimensiomatriisi(muuttuva);
        int lkmPii = this.DM.laskeLkm();
        String[][] pii = new String[lkmPii][];
        int lkmSuureet = M.getRivit();
        int lkmVak = 0;
        int idAihe = 0;
        if (!aihe.equals("")) {
            idAihe = this.aiheet.etsi(aihe).getIdAihe();
        }
        if (this.aiheet.onkoVak(aihe)) {
            Vector v = this.piiluvut.getPiiluvut();
            int k = 0;
            Iterator i = v.iterator();
            while (i.hasNext()) {
                Matriisi potenssit;
                Piiluku piiluku = (Piiluku)i.next();
                ArrayList listPotenssit = piiluku.getPotenssit();
                ArrayList suureet = piiluku.getSuureet();
                if (!this.valitut.containsAll(suureet) || suureet.contains(this.valitut.get(0)) || !this.DM.onkoRatkaisu(potenssit = this.jarjesta(listPotenssit, suureet))) continue;
                String[] apu = potenssit.getRiviTaulukko(0);
                pii[k] = new String[lkmSuureet + 1];
                int j = 0;
                while (j < lkmSuureet) {
                    pii[k][j] = apu[j];
                    ++j;
                }
                pii[k][lkmSuureet] = piiluku.getNimi() + "  " + piiluku.getSymboli();
                ++k;
            }
        }
        lkmVak = this.DM.getLkmVak();
        this.DM.alusta();
        this.DM.yksinkertaista();
        Matriisi loput = this.DM.getPiiluvut();
        int i = lkmVak;
        while (i < lkmPii) {
            pii[i] = loput.getRiviTaulukko(i);
            ++i;
        }
        if (idPerussuure != -1) {
            this.teeTulostus(M, idAihe, idPerussuure);
        }
        return pii;
    }

    public Matriisi jarjesta(ArrayList listPotenssit, ArrayList suureet) {
        Matriisi M = new Matriisi(1, this.valitut.size());
        int i = 0;
        while (i < this.valitut.size()) {
            int j = suureet.indexOf(this.valitut.get(i));
            if (j >= 0) {
                double potenssi = Double.parseDouble((String)listPotenssit.get(j));
                M.setAlkio(0, i, potenssi);
            } else {
                M.setAlkio(0, i, 0.0);
            }
            ++i;
        }
        return M;
    }

    public Matriisi teeMatriisi(Set suureet, int idPerussuure, int idSuureRatk) {
        double[] dimensio = this.etsiDimensiot(idSuureRatk, idPerussuure);
        int rivit = suureet.size();
        Matriisi M = new Matriisi(rivit, dimensio.length);
        this.valitut = new ArrayList();
        this.valitut.add(0, "" + idSuureRatk);
        M.setRivi(0, dimensio);
        int j = 1;
        Iterator i = suureet.iterator();
        while (i.hasNext()) {
            int idSuure = Integer.parseInt((String)i.next());
            if (idSuure == idSuureRatk) continue;
            try {
                M.setRivi(j, this.etsiDimensiot(idSuure, idPerussuure));
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage() + " id:" + idSuure);
            }
            this.valitut.add(j, "" + idSuure);
            ++j;
        }
        return M;
    }

    public void teeTulostus(Matriisi M, int idAihe, int idPerussuure) {
        this.tulostus = new String[M.getRivit() + 1][M.getSarakkeet() + 1];
        String[] nimet = this.perussuureet.etsiNimet(idPerussuure);
        this.tulostus[0][0] = "";
        int i = 1;
        while (i < this.tulostus[0].length) {
            this.tulostus[0][i] = nimet[i - 1];
            ++i;
        }
        int i2 = 1;
        while (i2 < this.tulostus.length) {
            int idSuure = 0;
            try {
                idSuure = Integer.parseInt(((String)this.valitut.get(i2 - 1)).trim());
            }
            catch (Exception ex) {
                // empty catch block
            }
            Suure suure = this.suureet.etsi(idAihe, idSuure);
            this.tulostus[i2][0] = suure.getNimi() + "|" + suure.getSymboli();
            int j = 1;
            while (j < this.tulostus[0].length) {
                this.tulostus[i2][j] = "" + M.getAlkio(i2 - 1, j - 1);
                ++j;
            }
            ++i2;
        }
    }

    public void lueTiedostot() throws FileNotFoundException {
        this.aiheet.lueTiedosto();
        this.dimensiot.lueTiedosto();
        this.perussuureet.lueTiedosto();
        this.piiluvut.lueTiedosto();
        this.suureet.lueTiedosto();
    }

    public void lueTiedostotWWW(InputStream[] in) throws FileNotFoundException {
        this.aiheet.lueTiedostoWWW(in[0]);
        this.dimensiot.lueTiedostoWWW(in[1]);
        this.perussuureet.lueTiedostoWWW(in[2]);
        this.piiluvut.lueTiedostoWWW(in[3]);
        this.suureet.lueTiedostoWWW(in[4]);
    }

    public String lueOhje() throws FileNotFoundException {
        this.ohje.lueTiedosto();
        return this.ohje.getOhje();
    }

    public void tallennaTiedostot() throws FileNotFoundException {
        this.aiheet.tallennaTiedosto();
        this.dimensiot.tallennaTiedosto();
        this.perussuureet.tallennaTiedosto();
        this.suureet.tallennaTiedosto();
    }

    public Vector etsiSuureet(String aihe) {
        int idAihe = this.aiheet.etsi(aihe).getIdAihe();
        if (idAihe == -1) {
            return null;
        }
        return this.etsiSuureet(idAihe);
    }

    public Suure etsiSuure(String nimi) {
        return this.suureet.etsi(nimi);
    }

    public Vector etsiSuureet(int idAihe) {
        return this.suureet.etsi(idAihe);
    }

    public double[] etsiDimensiot(int idSuure, int idPerussuure) {
        return this.dimensiot.etsi(idSuure, idPerussuure);
    }

    public Dimensio etsiDimensio(int idSuure, int idPerussuure) {
        return this.dimensiot.etsiDimensio(idSuure, idPerussuure);
    }

    public Aihe etsiAihe(String nimi) {
        return this.aiheet.etsi(nimi);
    }

    public Vector etsiPerussuureet(String aihe) {
        int idAihe = this.aiheet.etsi(aihe).getIdAihe();
        return this.etsiPerussuureet(idAihe);
    }

    public Vector etsiPerussuureet(int idAihe) {
        return this.perussuureet.etsi(idAihe);
    }

    public Perussuure etsiPerussuure(String symbolit) {
        return this.perussuureet.etsi(symbolit);
    }

    public Perussuure etsiPerussuure(ArrayList symbolit) {
        return this.perussuureet.etsi(symbolit);
    }

    public boolean onkoPerussuure(int idAihe, Perussuure perus) {
        return perus.getAiheet().contains("" + idAihe);
    }

    public void lisaa(Aihe aihe) {
        this.aiheet.lisaa(aihe);
    }

    public void lisaa(Dimensio dimensio) {
        this.dimensiot.lisaa(dimensio);
    }

    public void lisaa(Suure suure) {
        this.suureet.lisaa(suure);
    }

    public boolean poista(int idAihe, int idSuure) {
        return this.suureet.poista(idAihe, idSuure);
    }

    public boolean poista(int idAihe) {
        return this.aiheet.poista(idAihe);
    }

    public boolean poista(String symbolit, int idAihe) {
        return this.perussuureet.poista(symbolit, idAihe);
    }

    public void lisaa(Perussuure perussuure) {
        this.perussuureet.lisaa(perussuure);
    }

    public static void main(String[] args) {
        Dimensioanalyysi dimensioanalyysi1 = new Dimensioanalyysi();
    }
}

