/*
 * Decompiled with CFR 0.152.
 */
package dimensioanalyysi;

import dimensioanalyysi.Matriisi;

public strictfp class Dimensiomatriisi {
    private int rank = -1;
    private int lkmVak = 0;
    private Matriisi A;
    private Matriisi B;
    private final double SMALL = 1.0E-10;

    public Dimensiomatriisi(double[][] taulukko) {
        this.A = new Matriisi(taulukko);
    }

    public Dimensiomatriisi(Matriisi A) {
        this.A = A;
    }

    public Matriisi getPiiluvut() {
        return this.B;
    }

    public int getLkmVak() {
        return this.lkmVak;
    }

    public int laskeLkm() {
        int i = 0;
        while (this.rank < 0) {
            double arvo;
            int k;
            double ref = 0.0;
            double nrm = 0.0;
            int l = 0;
            int j = i;
            while (j < this.A.getSarakkeet()) {
                nrm = 0.0;
                k = 0;
                while (k < this.A.getRivit()) {
                    arvo = this.A.getAlkio(k, j);
                    nrm += arvo * arvo;
                    ++k;
                }
                if (nrm > 1.0E-10) {
                    k = 0;
                    while (k < this.A.getRivit()) {
                        arvo = this.A.getAlkio(k, j) / Math.sqrt(nrm);
                        this.A.setAlkio(k, j, arvo);
                        ++k;
                    }
                }
                if (nrm > ref) {
                    ref = nrm;
                    l = j;
                }
                ++j;
            }
            if (ref < 1.0E-10) {
                this.rank = i;
                continue;
            }
            j = 0;
            while (j < this.A.getRivit()) {
                ref = this.A.getAlkio(j, i);
                this.A.setAlkio(j, i, this.A.getAlkio(j, l));
                this.A.setAlkio(j, l, ref);
                ++j;
            }
            j = i + 1;
            while (j < this.A.getSarakkeet()) {
                nrm = 0.0;
                ref = 0.0;
                k = 0;
                while (k < this.A.getRivit()) {
                    ref += this.A.getAlkio(k, i) * this.A.getAlkio(k, j);
                    ++k;
                }
                k = 0;
                while (k < this.A.getRivit()) {
                    arvo = this.A.getAlkio(k, j);
                    this.A.setAlkio(k, j, arvo - ref * this.A.getAlkio(k, i));
                    ++k;
                }
                ++j;
            }
            if (++i < this.A.getSarakkeet()) continue;
            this.rank = this.A.getSarakkeet();
        }
        this.B = new Matriisi(this.A.getRivit() - this.rank, this.A.getRivit());
        return this.A.getRivit() - this.rank;
    }

    public boolean onkoRatkaisu(Matriisi potenssit) {
        if (this.A.getRivit() - this.rank <= this.lkmVak) {
            return false;
        }
        Matriisi vastaus = null;
        vastaus = Matriisi.kerro(potenssit, this.A, vastaus);
        int i = 0;
        while (i < vastaus.getSarakkeet()) {
            if (vastaus.getAlkio(0, i) > 1.0E-10) {
                return false;
            }
            ++i;
        }
        this.B.setRivi(this.lkmVak++, potenssit.getRivi(0));
        return true;
    }

    public void alusta() {
        int i = this.lkmVak;
        while (i < this.B.getRivit()) {
            int k;
            double ref;
            int j = 0;
            while (j < this.B.getSarakkeet()) {
                this.B.setAlkio(i, j, Math.random());
                ++j;
            }
            int j2 = 0;
            while (j2 < this.rank) {
                ref = 0.0;
                int k2 = 0;
                while (k2 < this.A.getRivit()) {
                    ref += this.A.getAlkio(k2, j2) * this.B.getAlkio(i, k2);
                    ++k2;
                }
                k = 0;
                while (k < this.A.getRivit()) {
                    double arvo = this.B.getAlkio(i, k) - ref * this.A.getAlkio(k, j2);
                    this.B.setAlkio(i, k, arvo);
                    ++k;
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < i) {
                ref = 0.0;
                k = 0;
                while (k < this.B.getSarakkeet()) {
                    ref += this.B.getAlkio(j3, k) * this.B.getAlkio(i, k);
                    ++k;
                }
                int k3 = 0;
                while (k3 < this.B.getSarakkeet()) {
                    double uusi = this.B.getAlkio(i, k3) - ref * this.B.getAlkio(j3, k3);
                    this.B.setAlkio(i, k3, uusi);
                    ++k3;
                }
                ++j3;
            }
            double nrm = 0.0;
            int j4 = 0;
            while (j4 < this.B.getSarakkeet()) {
                nrm += this.B.getAlkio(i, j4) * this.B.getAlkio(i, j4);
                ++j4;
            }
            nrm = 1.0 / Math.sqrt(nrm);
            int j5 = 0;
            while (j5 < this.B.getSarakkeet()) {
                double arvo = this.B.getAlkio(i, j5) * nrm;
                this.B.setAlkio(i, j5, arvo);
                ++j5;
            }
            int j6 = 0;
            while (j6 < this.B.getSarakkeet()) {
                double alkio = this.B.getAlkio(i, j6);
                if (Math.abs(alkio) < 1.0E-10) {
                    this.B.setAlkio(i, j6, 0.0);
                }
                ++j6;
            }
            ++i;
        }
    }

    public void yksinkertaista() {
        double uusi;
        int j;
        double ref;
        int l;
        int i;
        Matriisi M;
        int k = 0;
        if (this.lkmVak == 0) {
            M = this.B;
        } else {
            M = new Matriisi(this.B.getRivit() - this.lkmVak, this.B.getSarakkeet());
            i = 0;
            while (i < M.getRivit()) {
                M.setRivi(i, this.B.getRivi(this.lkmVak - 1 + i));
                ++i;
            }
        }
        i = 0;
        while (i < M.getRivit()) {
            l = i;
            ref = 0.0;
            while (ref < 1.0E-9 && l < M.getSarakkeet()) {
                k = i;
                j = i;
                while (j < M.getRivit()) {
                    if (Math.abs(M.getAlkio(j, l)) > ref) {
                        ref = Math.abs(M.getAlkio(j, l));
                        k = j;
                    }
                    ++j;
                }
                if (!(ref < 1.0E-9)) continue;
                ++l;
            }
            if (l >= M.getSarakkeet()) {
                l = M.getSarakkeet() - 1;
            }
            if (k != i) {
                j = l;
                while (j < M.getSarakkeet()) {
                    ref = M.getAlkio(i, j);
                    M.setAlkio(i, j, M.getAlkio(k, j));
                    M.setAlkio(k, j, ref);
                    ++j;
                }
            }
            j = i + 1;
            while (j < M.getRivit()) {
                if (Math.abs(M.getAlkio(j, l)) > 1.0E-9) {
                    ref = M.getAlkio(j, l) / M.getAlkio(i, l);
                    if (Double.isNaN(ref)) {
                        System.out.println("ekaNan:" + M.getAlkio(j, l) + " / " + M.getAlkio(i, l));
                    }
                    if (Double.isInfinite(ref)) {
                        System.out.println("ekaInf" + M.getAlkio(j, l) + " / " + M.getAlkio(i, l));
                    }
                    M.setAlkio(j, l, 0.0);
                    k = l + 1;
                    while (k < M.getSarakkeet()) {
                        uusi = M.getAlkio(j, k) - ref * M.getAlkio(i, k);
                        M.setAlkio(j, k, uusi);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < M.getSarakkeet()) {
            j = i;
            while (j < M.getRivit()) {
                if (Math.abs(M.getAlkio(i, j)) > 1.0E-9) {
                    k = i - 1;
                    while (k >= 0) {
                        if (Math.abs(M.getAlkio(k, j)) > 1.0E-9) {
                            ref = M.getAlkio(k, j) / M.getAlkio(i, j);
                            if (Double.isNaN(ref)) {
                                System.out.println("tokaNan");
                            }
                            if (Double.isInfinite(ref)) {
                                System.out.println("tokaInf");
                            }
                            M.setAlkio(k, j, 0.0);
                            l = j + 1;
                            while (l < M.getSarakkeet()) {
                                uusi = M.getAlkio(k, l) - ref * M.getAlkio(i, l);
                                M.setAlkio(k, l, uusi);
                                ++l;
                            }
                        }
                        --k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < M.getRivit()) {
            ref = 0.0;
            j = i;
            while (j < M.getSarakkeet()) {
                if (Math.abs(M.getAlkio(i, j)) > 1.0000000000000001E-7) {
                    ref = M.getAlkio(i, j);
                    break;
                }
                ++j;
            }
            if (Math.abs(ref) > 1.0E-12) {
                j = i;
                while (j < M.getSarakkeet()) {
                    uusi = M.getAlkio(i, j) / ref;
                    M.setAlkio(i, j, uusi);
                    ++j;
                }
            }
            j = 0;
            while (j < M.getSarakkeet()) {
                double alkio = M.getAlkio(i, j);
                if (Math.abs(alkio) < 1.0E-8) {
                    M.setAlkio(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < M.getRivit()) {
            this.B.setRivi(this.lkmVak + i, M.getRivi(i));
            ++i;
        }
    }

    public static void main(String[] args) {
        double[][] heiluri = new double[][]{{0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, -2.0}};
        double[][] betoni = new double[][]{{3.0, -1.0, 0.0}, {-3.0, 0.0, 1.0}, {0.0, -1.0, 0.0}, {2.0, 0.0, 0.0}, {0.0, -1.0, 1.0}};
        double[][] testi = new double[][]{{0.0, 0.0, -2.0}, {0.0, 1.0, 0.0}, {1.0, 2.0, 0.0}, {0.0, 0.0, -1.0}};
        Matriisi mTesti = new Matriisi(testi);
        Dimensiomatriisi testiDM = new Dimensiomatriisi(mTesti);
        testiDM.laskeLkm();
        testiDM.alusta();
        System.out.println("ennen:  " + testiDM.getPiiluvut());
        testiDM.yksinkertaista();
        System.out.println("j\u00e4lkeen:  " + testiDM.getPiiluvut());
    }
}

